/*
	File: CEG_sound.sqf
	Version: 1.1
	Author: Loyalguard

	Description:
	A script to emit a sound or noise from game logics assigned/co-located with certain CEG objects.

	Parameters:
	_this select 0: The CEG object co-located with game logics that will emit sound. (string)
 
	Execution:
	Executed from CEG_common.sqf on all machines except MP dedicated servers (since there is no one there to hear the sound).  Multiple instances of this script will be running concurrently, one for every object in the simulation.
*/

if (!isNil "CEG_DEBUG") then {_debug = ["CEG_sounds.sqf: Thread started for:", (_this select 1)] call LGD_fnc_debugMessage;}; //DEBUG 

// Scope //
private ["_effect", "_obj", "_onStr", "_logicStr", "_logic", "_sound1Str", "_sound1", "_sound2Str", "_sound2"];

// Parameter(s) //
_effect = (_this select 0);
_obj = (_this select 1);

// Assign local variables to store necessary information for the script to function.
_onStr = (format ["CEG_on_%1", _obj]);
_logicStr = (format ["CEG_logic_%1", _obj]);
_logic = missionNameSpace getVariable _logicStr; // The primary logic assigned to this object.
_sound1Str = (format ["CEG_sound_1_%1", _obj]);
_sound1 = missionNameSpace getVariable _sound1Str; // The 1st sound logic assigned to this object.
_sound2Str = (format ["CEG_sound_2_%1", _obj]);
_sound2 = missionNameSpace getVariable _sound2Str; // The 2nd sound logic assigned to this object.

// Determine which sound(s) to emit depending on the type of of object (Transformer "XFMR" or power plant "PLANT").
switch (_effect) do
{
    
	case "XFMR":
    {
		// Ensure power is on before beginning the loop.
		waitUntil {!isNil _onStr};	
		waitUntil {(missionNameSpace getVariable _onStr)};
		
		// As long as the power is on for this object, make the sound logic play a loop of transformer humming noise if the player is close enough to hear it.	  Two sound sources are used so they are no gaps in the loop.
		while {(missionNameSpace getVariable _onStr)} do
		{
			while {(missionNameSpace getVariable _onStr) && (_logic distance player < 50)} do 
			{
				_sound1 say ["CEG_Hum",5];
				sleep 1.25;
				_sound2 say ["CEG_Hum",5];
				sleep 1.25;
			};
			sleep .001;
		};
    };
	
    case "PLANT":
    {
		// Esure power is on before beginning the loop.
		waitUntil {!isNil _onStr};	
		waitUntil {(missionNameSpace getVariable _onStr)};
				
		// As long as the power is on for this object, make the sound logic play a loop of power plant noises if the player is close enough to hear it.  Two sound sources are used so they are no gaps in the loop.
		while {(missionNameSpace getVariable _onStr)} do
		{
			while {(missionNameSpace getVariable _onStr) && (_logic distance player < 40)} do 
			{
				_sound1 say ["CEG_Plant",5];
				sleep 1;
				_sound2 say ["CEG_Plant",5];
				sleep 1;
			};
			sleep .001;
		};			
    };
};

if (!isNil "CEG_DEBUG") then {_debug = ["CEG_sounds.sqf: Thread finished for:", (_this select 1)] call LGD_fnc_debugMessage;}; //DEBUG 